/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/***********************************************************************
* File name     : regconst.h
************************************************************************
* Written by    : Joerg Weedermann, BID R&D, 19.3.96
* Last modified : 26.3.96
************************************************************************
* File contents : 
*		  register file symbolic name definitions
*                 !!! MUST MATCH definitions in regconst.c !!!!!
************************************************************************
* NOTES :
************************************************************************
*/

#ifndef REGCONST_H_INCLUDED
#define REGCONST_H_INCLUDED


#ifndef BEST_FIRMWARE

/* **************************** CAPI only ******************************** */

/* special values */
#define RESET_DETECT_VALUE   0x123455aaUL

/* SCR; 12.97; mechanism to permit code to operate with one of 2 different
 * register address sets...(i.e. 2926 and unaltered 2925).
 * Note that the register set arrays are uni-dimensional for speed.
 */

/* defined in regconst.c ... copy is here for clarity; PLEASE MAINTAIN !! */

/*
const b_int32 PciCommand[] =      {0x00UL, 0xABUL};  moved from 00 to ab, CZ 
const b_int32 BestStatusMini[] =  {0x01UL, 0xACUL};  moved from 01 to ac, CZ 
const b_int32 BoardRstmode[] =    {0x02UL, 0xADUL};  moved from 02 to ad, CZ 
const b_int32 BiosString[] =      {0xEBUL, 0x04UL};  moved from eb to 04, CZ 
const b_int32 ProductString[] =   {0xECUL, 0x02UL};  moved from ec to 05 to 02, CZ, SCR
const b_int32 DummyRegister[] =   {0xFFUL, 0x0AUL};  moved from ff to 0a, CZ 
 */

/* for the 2926 type of register set; 
 * registers <= REG_COMMON_MAX use 2925 I/O methods (i.e. BestBasicCommand8Bit())
 */
#define REG_COMMON_MAX  0x0FUL


extern b_handlestype handle_array[];


/* SCR; 4.12.97; Note; I did actually check to make sure that all calls within
 * the CAPI that currently include this define also use "handle"
 * as the index....if you're here then that might be your problem !!
 */

#define REG_INDEX handle_array[handle].regindex

#define REG_INDX_2925 0
#define REG_INDX_2926 1

typedef struct _MULT_REG_WIDTHS
{
  b_sizetype CardModel[2];  /* use REG_INDX_2925 and REG_INDX_2926 ONLY */

} MULT_REG_WIDTHS;


#ifndef COMPILING_REGCONST_C

  extern const MULT_REG_WIDTHS b_regsize[];

  extern b_int32 RegPciCommand[];
  extern b_int32 RegBestStatusMini[];
  extern b_int32 RegBoardRstmode[];
  extern b_int32 RegBiosString[];
  extern b_int32 RegProductString[];
  extern b_int32 RegDummyRegister[];

#endif  /* COMPILING_REGCONST_C */

#define PCI_COMMAND          RegPciCommand[REG_INDEX]
#define BEST_STATUS_MINI     RegBestStatusMini[REG_INDEX]
#define BOARD_RSTMODE        RegBoardRstmode[REG_INDEX]

#define BIOS_STRING          RegBiosString[REG_INDEX]
#define PRODUCT_STRING       RegProductString[REG_INDEX]
#define DUMMY_REGISTER       RegDummyRegister[REG_INDEX]

#define VERSION_CODE	     0x0000000DUL	/* E2926A only */


#else

/* firmware: the value does not rely matter. Any function where it could
   be passed to are dead ends. CZ */
#define PCI_COMMAND	     0x00000000UL


#endif /* CAPI only */


#define BUS_ADDR_LO          0x00000010UL
#define INT_ADDR             0x00000011UL
#define BUS_CMD              0x00000012UL
#define BYTEN                0x00000013UL
#define N_OF_TRANSFERS       0x00000014UL
#define M_ATTR               0x00000017UL
#define T_ATTR               0x00000018UL
#define MBLK_RUN_PAGE_NUM    0x0000001AUL
#define MBLK_PROG_PAGE_NUM   0x0000001BUL
#define MBLK_READ_OFFSET     0x0000001CUL
#define MBLK_READ_PAGE       0x0000001DUL
#define COMPARE_ONLY         0x0000001EUL
#define COMPARE_RESULT       0x0000001FUL

#define MGEN_RUNMODE         0x00000020UL
#define MGEN_REPEAT          0x00000021UL
#define MGEN_DELAYCTR        0x00000022UL
#define MGEN_TIMER           0x00000023UL
#define MGEN_LATMODE         0x00000024UL
#define MGEN_LATCTR          0x00000025UL
#define MGEN_CACHESIZE       0x00000026UL
#define TGEN_RUNMODE         0x00000027UL
#define MGEN_MWI             0x00000028UL
#define MGEN_MENABLE         0x00000029UL
#define MGEN_ATTRMODE        0x0000002AUL

#define CONF_SPACE_OFFS      0x00000030UL
#define CONF_SPACE_DATA      0x00000031UL
#define CONF_SPACE_MASK      0x00000032UL
#define INTR_GENERATE        0x00000033UL
#define CONF_PUMODE          0x00000034UL
#define SST_INTR_GEN         0x0000003fUL

#define OBS_ACCU_ERROR       0x00000040UL
#define OBS_FIRST_ERROR      0x00000041UL
#define OBS_MASK             0x00000042UL
#define OBS_COMMAND          0x00000043UL
#define OBS_INT              0x00000044UL
#define OBS_STATUS           0x00000045UL
#define OBS_MODE             0x00000046UL
#define OBS_PU_MODE          0x00000047UL
#define OBS_CLEAR            0x00000048UL

#define EXP_ROM_OFFS         0x00000050UL
#define EXP_ROM_DATA         0x00000051UL
#define EXP_ROM_MODE         0x00000052UL

#define RAM_OFFS             0x00000060UL
#define RAM_DATA             0x00000061UL
#define RAM_BYTEN            0x00000062UL
#define MBUF_SIZE            0x00000063UL
#define MBUF_ADDR            0x00000064UL
#define MBUF_DATA            0x00000065UL

#define ANA_TRIGGER_TYPE     0x00000070UL
#define ANA_PATTERN          0x00000071UL
#define ANA_CMD              0x00000072UL
#define ANA_ADDR_PTR         0x00000073UL
#define ANA_TRIGGER_POINT    0x00000074UL
#define ANA_LINES_CAPT       0x00000075UL
#define ANA_STATUS           0x00000076UL
#define ANA_DATA             0x00000077UL
#define ANA_PU_MODE          0x00000078UL
#define SQ_PATTERN           0x00000079UL
#define INT_PATTERN          0x0000007AUL
#define ANA_GAP              0x0000007BUL
#define TRC_CMD              0x0000007CUL
#define HEARTBEAT_VALUE      0x0000007DUL

#define ATTR_MEM_MODE        0x00000080UL
#define TATTR_PROG_PAGE_NUM  0x00000081UL
#define TATTR_PROG_OFFSET    0x00000082UL
#define TATTR_RUN_PAGE_NUM   0x00000083UL
#define MATTR_PROG_PAGE_NUM  0x00000084UL
#define MATTR_PROG_OFFSET    0x00000085UL
#define MATTR_RUN_PAGE_NUM   0x00000086UL
#define MATTR_CLEAR          0x00000087UL
#define TATTR_CLEAR          0x00000088UL

#define HEX_DISP_MODE        0x00000090UL
#define HEX_DISP_DATA        0x00000091UL
#define TEST_BANDWIDTH       0x00000092UL
#define TEST_BLK_LENGTH      0x00000093UL
#define TEST_PATTERN         0x00000094UL
#define TEST_PROTOCOL        0x00000095UL
#define TEST_COMPARE         0x00000096UL
#define TEST_START_ADDR      0x00000097UL
#define TEST_NO_OF_BYTES     0x00000098UL
#define TEST_SOURCE_ADDR     0x00000099UL
#define TEST_DEST_ADDR       0x0000009AUL
#define TEST_TIME_DIST       0x0000009BUL
#define TEST_TIME_LIMIT      0x0000009CUL
#define TEST_SETUP           0x0000009DUL
#define TEST_RUN             0x0000009EUL
#define TEST_S_BUFFER        0x0000009FUL

#define SIDEBAND_CONF        0x000000A0UL
#define SIDEBAND_OUTPUT      0x000000A1UL
#define SIDEBAND_INPUT       0x000000A2UL

#define CPU_PORT_SIZE        0x000000B0UL
#define CPU_PORT_ADDR        0x000000B1UL
#define CPU_PORT_DATA        0x000000B2UL
#define CPU_PORT_INTR        0x000000B3UL
#define CPU_PORT_DEVICE      0x000000B4UL
#define CPU_PORT_MODE        0x000000B5UL
#define CPU_PORT_PROTOCOL    0x000000B6UL
#define CPU_PORT_RDYTYPE     0x000000B7UL
#define CPU_PORT_RESET       0x000000B8UL

/* defines for CORE-BIOS */
#define DOWNLD_CMD           0x000000C0UL    
#define DOWNLD_BUF_DATA      0x000000C1UL   
#define DOWNLD_BUF_SIZE      0x000000C2UL  
#define DOWNLD_BUF_USED_LEN  0x000000C3UL 
#define BIOS_LOAD            0x000000C4UL
#define BIOS_ERASE           0x000000C5UL  
#define DBI_LOAD             0x000000C6UL 


/* defines for 26 core bios */
/* for the E2926A software the opcodes for core bios commands can be placed
   wherever desired because of the completely different structure of core
   bios and fimware commands. The additional security of having disjunct sets
   of commands (that did not exist in the 25 any more) is given up. */
#define FPROG_PREPARE	     0x00000020UL
#define SRECORD_LOAD	     0x00000021UL
#define HEXIMAG_LOAD	     0x00000022UL
#define HEXIMAG_PROG	     0x00000023UL
#define PU_DB_DISCARD	     0x0000002EUL
#define BOARD_RESET	     0x0000002FUL

#define FUN_LONGOPERATION    0x000000F0UL


/* defines for BIOS */
/* BufControl                0x000000C0UL        CORE: BYTE */
/* BufDataAccess             0x000000C1UL        CORE: BYTE */
/* BufSizeAccess             0x000000C2UL        CORE: DWORD */
/* BufUsedAccess             0x000000C3UL        CORE: DWORD */
#define SST_PU_MODE          0x000000C4UL     /* CORE: BYTE */

#define SST_CFG_CMD          0x000000C6UL     /* CORE: BYTE */
#define SST_DATA_GEN         0x000000C7UL
#define SST_HANDLER          0x000000C8UL
#define SST_CFG_PARAM        0x000000C9UL
#define SST_CFG_ADDR         0x000000CAUL
#define SST_CFG_DATA         0x000000CBUL
#define SST_PROP_ADDR        0x000000CCUL
#define SST_PROP_DATA        0x000000CDUL
#define SST_RESULT_ADDR      0x000000CEUL
#define SST_RESULT_DATA      0x000000CFUL

/* defines for BufControl */
#define FREE_BUFFER          0x00
#define ALLOC_BUFFER         0x01
#define RESET_PTR            0x02
#define DP_PROG              0x03
#define SM_PROG              0x04
#define LAT_PROG             0x05
#define XILINX_ERASE         0x06
#define XILINX_PROG          0x07
#define BIOS_SWITCH          0x08
#define LAT_PERF_PROG        0x09
#define XIL_PERF_ERASE       0x0A
#define XIL_PERF_PROG        0x0B
#define DBI_PERF_PROG        0x0C

#define DIRECT_ADDRESS       0x000000D0UL
#define DIRECT_DATA          0x000000D1UL
#define ATTRMEM_ADDR         0x000000D2UL
#define TATTR_DATA           0x000000D3UL
#define MATTR_DATA           0x000000D4UL
#define T_DEC_MODE           0x000000D5UL
#define T_DEC_SIZE           0x000000D6UL
#define T_DEC_BASE           0x000000D7UL
#define T_DEC_LOCATION       0x000000D8UL
#define T_DEC_PREFETCH       0x000000D9UL
#define T_DEC_PROG           0x000000DAUL
#define T_DEC_READ           0x000000DBUL
#define T_DEC_RESULT         0x000000DCUL
#define T_DEC_SPEED          0x000000DDUL
#define T_DEC_CONTROL        0x000000DEUL

#define PERF_XIL_DATE        0x000000DFUL

#define CORE_VERSION         0x000000E0UL
#define BIOS_VERSION         0x000000E1UL
#define SERVICE_CMD          0x000000E2UL
#define RS232_BAUDRATE       0x000000E3UL
#define DP_DATE_CODE         0x000000E4UL
#define SM_DATE_CODE         0x000000E5UL
#define DBI_DATE_CODE        0x000000E6UL
#define OBS_DATE_CODE        0x000000E7UL
#define CONF_DATE_CODE       0x000000E8UL
#define XIL_DATE_CODE        0x000000E9UL
#define CORE_STRING          0x000000EAUL


#define DTALTERA_DATE_CODE   0x000000EBUL

#if 0
/* obsolete, moved to 04, 05 */
#define BIOS_STRING          0x000000EBUL
#define PRODUCT_STRING       0x000000ECUL
#endif

#define SERIAL_STRING        0x000000EDUL
#define REVISION_STRING      0x000000EEUL
#define LATT_STRING          0x000000EFUL

#define MAILBOX_ACCESS       0x000000F0UL
#define COMPARE_CONTROL      0x000000F1UL
#define COMPARE_OFFSET       0x000000F2UL

#define TEST_TIMER_CTRL      0x000000F3UL
#define TEST_TIMER_ACTUAL    0x000000F4UL
#define TEST_TIMER_TERROR    0x000000F5UL
#define TEST_TIMER_PERROR    0x000000F6UL
#define TEST_TIMER_TTRIG     0x000000F7UL
#define TEST_BUFFER_LENGTH   0x000000F8UL
#define TEST_BUFFER          0x000000F9UL

#define PERF_DATE_STRING     0x000000FAUL
#define PERF_DATA            0x000000FBUL
#define PERF_COM             0x000000FCUL

#define ERR_COM              0x000000FDUL
#define ERR_DAT              0x000000FEUL

#if 0
#define DUMMY_REGISTER       0x000000FFUL	/* obsolete */
#endif


#define INT_ACK              0x0
#define SPECIAL              0x1
#define IO_READ              0x2
#define IO_WRITE             0x3
#define RESERVED_4           0x4
#define RESERVED_5           0x5
#define MEM_READ             0x6
#define MEM_WRITE            0x7
#define RESERVED_8           0x8
#define RESERVED_9           0x9
#define CONFIG_READ          0xa
#define CONFIG_WRITE         0xb
#define MEM_READMULTIPLE     0xc
#define MEM_READLINE         0xe
#define MEM_WRITEINVALIDATE  0xf

#define M_DO_LOOP         0x0001
#define M_COMPLETE        0x0002
#define M_RELEASE_REQ     0x0004
#define M_D_PERR          0x0008
#define M_A_SERR          0x0010
#define M_D_WRONG_PAR     0x0020
#define M_A_WRONG_PAR     0x0040
#define M_D_TOGGLE        0x0080
#define M_A_TOGGLE        0x0100

#define T_DO_LOOP         0x0001
#define T_NO_TERM         0x0000
#define T_RETRY           0x0002
#define T_DISCONN         0x0004
#define T_ABORT           0x0006
#define T_D_WRONG_PAR     0x0008
#define T_D_PERR          0x0010
#define T_D_SERR          0x0020
#define T_NOTERM          0x0000
#define T_RETRY           0x0002
#define T_DISCONNECT      0x0004
#define T_ABORT           0x0006


/* best commands */
#define MASTER_PHASE_PROG   0x0100
#define RUN_BLOCK_PAGE      0x0200
#define RUN_BLOCK           0x0300
#define STOP                0x0400
#define PCI_RESET_SM        0x0500
#define MASTER_PHASE_READ   0x0600
#define PCI_BLOCK_PROG      0x0700
#define TARGET_PHASE_PROG   0x0800
#define TARGET_PHASE_READ   0x0900
#define SYS_RESET           0x0A00
#define PCI_BLOCK_READ      0x0B00


/* service commands */
#define CORE_SWITCH                   0x01
#define SAVE_BOARD_CONFIG             0x02
#define RESTORE_BOARD_CONFIG          0x03
#define RESTORE_BOARD_DEFAULT_CONFIG  0x04
#define LOCK_BOARD                    0x05

#endif
